<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/info', 'Home::index');

$routes->get('/', 'Discover::index');
$routes->get('/categories', 'Discover::categories_index');
$routes->get('/latest-radios', 'Discover::radios_index');
$routes->get('/countries', 'Discover::countries_index');
$routes->get('/podcast', 'Discover::podcast_index');

$routes->get('/categories/(:any)/(:num)', 'Discover::categories/$1/$2');
$routes->get('/countries/(:any)/(:num)', 'Discover::countries/$1/$2');
$routes->get('/banner/(:any)/(:num)', 'Discover::banner/$1/$2');

$routes->get('/about-us', 'Discover::about_index');
$routes->get('/privacy-policy', 'Discover::policy_index');
$routes->get('/terms-condition', 'Discover::terms_index');

$routes->get('/search', 'Discover::search_index');

// Station ---------------------------------------------------------------------
$routes->get('/station', 'Station::index');
$routes->get('/station/(:any)/(:num)', 'Station::radio_id/$1/$2');
$routes->get('/update_view/(:num)', 'Station::update_view/$1');
$routes->get('/episode/(:num)', 'Station::podcast_id/$1');
$routes->get('/embedded', 'Station::index');
$routes->get('/embedded/(:num)', 'Station::embedded_index/$1');

$routes->get('/login', 'Login::index');
$routes->add('/login/user_login', 'Login::user_login_validate');
$routes->get('/login/logout', 'Login::logout');

$routes->get('/register', 'Login::register_index');
$routes->add('/register/register_store', 'Login::register_store');

$routes->get('/add-suggestion', 'Login::suggestion_add');
$routes->add('/add-suggestion/suggestion_store', 'Login::suggestion_store');

// Profile----------------------------------------------------------------------
$routes->get('/profile', 'Login::profile');
$routes->group('profile', static function ($routes) {
    $routes->add('data_update', 'Login::profile_update');
    $routes->add('password_update', 'Login::profile_pass_update');
    $routes->add('notification_clear', 'Login::notification_update');
});

// Reports ---------------------------------------------------------------------
$routes->get('/reports', 'Station::index');
$routes->group('reports', static function ($routes) {
    $routes->get('(:num)', 'Login::reports_id/$1');
    $routes->add('reports_store', 'Login::reports_store');
});